/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.context;

import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.PrepareCache;
import net.skinsrestorer.shadow.mariadb.client.ServerVersion;
import net.skinsrestorer.shadow.mariadb.export.ExceptionFactory;
import net.skinsrestorer.shadow.mariadb.message.server.InitialHandshakePacket;

public class BaseContext
implements Context {
    private final long threadId;
    private final long serverCapabilities;
    private final long clientCapabilities;
    private final byte[] seed;
    private final ServerVersion version;
    private final boolean eofDeprecated;
    private final boolean skipMeta;
    private final boolean extendedInfo;
    private final Configuration conf;
    private final ExceptionFactory exceptionFactory;
    protected int serverStatus;
    private String database;
    private int transactionIsolationLevel;
    private int warning;
    private final PrepareCache prepareCache;
    private int stateFlag = 0;

    public BaseContext(InitialHandshakePacket handshake, long clientCapabilities, Configuration conf, ExceptionFactory exceptionFactory, PrepareCache prepareCache) {
        this.threadId = handshake.getThreadId();
        this.seed = handshake.getSeed();
        this.serverCapabilities = handshake.getCapabilities();
        this.serverStatus = handshake.getServerStatus();
        this.version = handshake.getVersion();
        this.clientCapabilities = clientCapabilities;
        this.eofDeprecated = this.hasClientCapability(0x1000000L);
        this.skipMeta = this.hasClientCapability(0x1000000000L);
        this.extendedInfo = this.hasClientCapability(0x800000000L);
        this.conf = conf;
        this.database = conf.database();
        this.exceptionFactory = exceptionFactory;
        this.prepareCache = prepareCache;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public byte[] getSeed() {
        return this.seed;
    }

    @Override
    public boolean hasServerCapability(long flag) {
        return (this.serverCapabilities & flag) > 0L;
    }

    @Override
    public boolean hasClientCapability(long flag) {
        return (this.clientCapabilities & flag) > 0L;
    }

    @Override
    public int getServerStatus() {
        return this.serverStatus;
    }

    @Override
    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public ServerVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean isEofDeprecated() {
        return this.eofDeprecated;
    }

    @Override
    public boolean isExtendedInfo() {
        return this.extendedInfo;
    }

    @Override
    public boolean canSkipMeta() {
        return this.skipMeta;
    }

    @Override
    public int getWarning() {
        return this.warning;
    }

    @Override
    public void setWarning(int warning) {
        this.warning = warning;
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    @Override
    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    @Override
    public PrepareCache getPrepareCache() {
        return this.prepareCache;
    }

    @Override
    public void resetPrepareCache() {
        this.prepareCache.reset();
    }

    @Override
    public int getStateFlag() {
        return this.stateFlag;
    }

    @Override
    public void resetStateFlag() {
        this.stateFlag = 0;
    }

    @Override
    public void addStateFlag(int state) {
        this.stateFlag |= state;
    }
}

